
//~~~~~~~~~~~~~~~~~~~~~~~~~~~
#include <gc.h>
//~~~~~~~~~~~~~~~~~~~~~

void RenderSineSqrBar( TGC* gc, INT32 x );

/******************************************************************************
*
*  Render_barpulse
*
*******************************************************************************
*  Draws modulated pulse, sine-squared pulse, and bar.
*
*******************************************************************************
*  Usage:
*     Render_barpulse( TGC* gc );
*
*  Arguments:
*     gc - the graphics context being drawn on.
*
*  Returns:
*     bool completed - true if the image could be drawn.
*                    - false if it can't be drawn.
*
*******************************************************************************
*/
bool Render_barpulse( TGC* gc )
{
  INT32 i, n, w, x;
  n = 0;

  if( gc->GetPixelRate() > 100.0e6 ) return false;

  gc->Versions(0);
  gc->SetLut( BW|HUERGB|HUEPULSE|GRAYPULSE|NOGAMMA );
  gc->Opaque( TStdColor::black, TStdColor::black );
  gc->DrawLine( gc->left, gc->top, gc->right, gc->top );

  //*** Draw the Pulse
  x = (INT32)((double)gc->width * 0.10);

  //*** Fetch number of samples in rise
 	n = huepulse[0];

  //*** Draw the midpoint
  gc->Transparent( huepulse[n] );
  gc->DrawPoint  ( x, 0 );

  //*** Draw the rise and fall
  for( i = 1; i <= n; i++ )
  {
    gc->Transparent( huepulse[i] );
    gc->DrawPoint  ( x - (n - i), 0 );
    gc->DrawPoint  ( x + (n - i), 0 );
    if( gc->Proceed() == false ) return true;
  }

  //*** Draw the Bar
  x = (INT32)((double)gc->width * 0.20);
  RenderSineSqrBar( gc, x );

  //*** Draw the Window
  x = (INT32)((double)gc->width * 0.25);
  w = (INT32)((double)gc->width * 0.75 - x);

  //*** Draw the white section
  gc->Transparent( TStdColor::white );
  gc->FillRect( w, 1, x, 0 );

  //*** Draw the sides
 	n = graypulse[0];
  for( i = 1; i <= n; i++ )
  {
    gc->Transparent( graypulse[i] );
    gc->DrawPoint  ( x - ((n + 1) - i), 0 );
    gc->DrawPoint  ( x + ((n + 1) - i) + w - 1, 0 );
    if( gc->Proceed() == false ) return true;
  }

  //*** Fast mode disables any time consuming pixel processing, which we
  //*** don't need in this simple case.
  gc->FastMode( 1 );

  //*** Fill the screen
  gc->CurtainFillRect( gc->width, gc->height, 0, 0, 0 );

  return true;
}

void RenderSineSqrBar( TGC* gc, INT32 x )
{
  INT32 i, n ;

  /* Draw the center. (white point) */
  gc->Transparent( TStdColor::white );
  gc->DrawPoint( x, 0 );

  /* Draw the sides. */
  n = graypulse[0];
  for( i = 1; i <= n; i++ )
  {
    gc->Transparent( graypulse[i] );
    gc->DrawPoint  ( x - (n + 1 - i), 0 );
    gc->DrawPoint  ( x + (n + 1 - i), 0 );
    if( gc->Proceed() == false ) return;
  }
}



